<?php
class SmsFlyC {
    private $baseurl = 'http://sms-fly.com/api/api.php';
    private $login;
    private $password;
    private $source;

    public function __construct($login, $password, $source="InfoCentr")
    {
        $this->login = $login;
        $this->password = $password;
        $this->source = htmlspecialchars($source);
    }

    public function sfDebug($var,$exit = true)
    {
        echo "<pre>";
        var_dump($var);
        if ($exit) {
            exit();
        }
    }

    public function sfSendSms($settings)
    {
        $source         = $this->source;
        $recipient      = $settings['SF_PHONE'];
        $text           = htmlspecialchars($settings['SF_TEXT']);
        $start_time     = 'AUTO';
        $end_time       = 'AUTO';
        $rate           = 1;
        $lifetime       = 4;
        $description    = '';
        $version        = 'bitrix 1.0.0';
        //$params['to'] = preg_replace("/[^0-9+]/", '', $params['to']);

        $textQuery 	 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        $textQuery 	.= "<request>";
        $textQuery 	.= "<operation>SENDSMS</operation>";
        $textQuery 	.= '		<message start_time="'.$start_time.'" end_time="'.$end_time.'" lifetime="'.$lifetime.'" rate="'.$rate.'" desc="'.$description.'" source="'.$source.'" version="'.$version.'">'."\n";
        $textQuery 	.= "		<body>".$text."</body>";
        $textQuery 	.= "		<recipient>".$recipient."</recipient>";
        $textQuery 	.=  "</message>";
        $textQuery 	.= "</request>";

        if ($this->sfQuery($textQuery)) {
            return true;
        }
    }

    public function sfBalance()
    {
        $textQuery 	 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        $textQuery 	.= "<request>";
        $textQuery 	.= "<operation>GETBALANCE</operation>";
        $textQuery 	.= "</request>";

        $responce = $this->sfQuery($textQuery);
        return $this->sfParser($responce,'balance');
    }

    private function sfQuery ($textQuery)
    {
        $auth = $this->login.':'.$this->password;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERPWD , $auth);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_URL, $this->baseurl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: text/xml", "Accept: text/xml"));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $textQuery);
        $result = curl_exec($ch);
        curl_close($ch);

        if ($result) {
            return $result;
        }
        return false;
    }

    private function sfParser ($obj, $child, $attribut=null)
    {
        $xml = new SimpleXMLElement($obj);
        if ($child == 'balance') {
            $result = "У Вас на счету ".(string)$xml->balance. " грн. ";
        } else {
            $result = "Нет информации для отображения.";
        }
        return $result;
    }
}