<?php

class NPflyC {
    private $apiKey;
    public function __construct($apiKey) {
        $this->apiKey = $apiKey;
    }

    function checkKey() {
        $response = $this->query([
            "modelName" => "Common",
            "calledMethod" => "getServiceTypes"
        ], false);
        return !!$response['success'];
    }

    function findTTN($telephone, $date_added,  $textTemplate) {
        $ttns = $this->getDocumentList($telephone, $date_added);

        $templates = ['{NP_TTN}','{NP_FIO}', '{NP_OTD}', '{NP_DATE}'];

        $textttn = [];
        if ( $ttns['success'] && $ttns['data'] ) {
            foreach ($ttns['data'] as $result) {
                foreach ($result['result'] as $i => $ttn) {
                    $np_fields = [$ttn['Number'], $ttn['RecipientName'], $ttn['RecipientAddressDescription'], date('d.m.Y', strtotime($ttn['ScheduledDeliveryDate']))];
                    $textttn[] = str_replace($templates, $np_fields, htmlspecialchars_decode($textTemplate));
                }
            }
        }
        return implode('; ', $textttn);
    }

    function getDocumentList($telephone, $firstDate, $lastDate = null) {
        $DateTimeFrom = date('d.m.Y', strtotime($firstDate));
        $lastDate = empty($lastDate) ? time() : strtotime($lastDate);
        $DateTimeTo = date('d.m.Y', $lastDate);

        $data = [
            'modelName' => 'InternetDocument',
            'calledMethod' => 'getOutgoingDocumentsByPhone',
            'methodProperties' => [
                "DateTimeFrom" => $DateTimeFrom,
                "DateTimeTo" => $DateTimeTo,
                "GetFullList" => "1",
                "PhoneRecipient" => $telephone
            ]
        ];
        return $this->query($data);
    }

    private function query(array $data, $logged = true){
        if ($logged) $this::oclog($data);
        $data['apiKey'] = $this->apiKey;

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.novaposhta.ua/v2.0/json/",
            CURLOPT_RETURNTRANSFER => True,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array("content-type: application/json",),
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
            $this::oclog($err);
        } else {
            if ($logged) $this::oclog($response);
            return json_decode($response, 1);
        }
    }

    static function oclog($message) {
        $log = new Log('smsflynp.log');
        $log->write($message);
    }
}