<?php
class SMSflyC {
    private $baseurl = 'https://sms-fly.ua/api/v2/api.php';
    private $apikey, $balanceuah, $lastactionstatus = true;
    private $sourceList = [], $sourceSMS, $sourceViber;
    private $appversion = 'opencart 3.4.2';

    public function __construct($apikey) {
        $this->apikey = $apikey;
        $this->setSources();
    }

    public function setSources($sourceSMS = null, $sourceViber = null) {
        $this->sourceSMS = empty($sourceSMS) ? '' : $sourceSMS;
        $this->sourceViber = empty($sourceViber) ? '' : $sourceViber;
    }

    public function __get($name) {
        switch ($name) {
            case 'auth': return $this->lastactionstatus;
            case 'names':
                if ( count($this->sourceList) === 0 ) {
                    $params = ["action" => "GETSOURCES", "data" => ["channels"=> ["sms", "viber"]]];

                    $responce = $this->apiquery($params);

                    $names['sms'] = isset($responce['data']['sms']) ? $responce['data']['sms'] : [];
                    $names['viber'] = isset($responce['data']['viber']) ? $responce['data']['viber'] : [];

                    $this->sourceList = $names;
                }

                return $this->sourceList;
            case 'balance':
                if ( empty($this->balanceuah) ) {
                    $params = ["action" => "GETBALANCE"];

                    $responce = $this->apiquery($params);

                    $this->balanceuah = isset($responce['data']['balance']) ? $responce['data']['balance'] : 0;
                }

                return $this->balanceuah;
            default: return null;
        }
    }

    private function apiquery (array $params) {
        $params['auth'] = [
            'key' => $this->apikey,
            'appversion' => $this->appversion,
            //'user_agent' => $_SERVER['HTTP_USER_AGENT']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_URL, $this->baseurl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/json", "Accept: application/json"));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params, JSON_UNESCAPED_UNICODE));
        $result = ($this->lastactionstatus) ? curl_exec($ch) : null;
        curl_close($ch);

        if ( !empty($result) ) {
            $response = json_decode($result, true);
            $falseStatuses = ['FORBIDDEN', 'INSUFFICIENTFUNDS'];
            $this->lastactionstatus = !(isset($response['error']['code']) && in_array($response['error']['code'], $falseStatuses));
            return $response;
        }
        return false;
    }

    public function sendSMS($phone, $text) {
        if ( empty($this->sourceSMS) ) {
            return self::craftError('INVSOURCE', 'empty phone');
        }

        $recipient      = self::checkPhone($phone);
        if ( !$recipient ) {
            return self::craftError('INVROUTE', $phone);
        }
        $text           = htmlspecialchars($text);

        $params = [
            "action" => "SENDMESSAGE",
            "data" => [
                "recipient" => $recipient,
                "channels" => ["sms"],
                "sms" => [
                    "source" => $this->sourceSMS,
                    "text" => $text
                ]
            ]
        ];

        return $this->apiquery($params);
    }

    public function sendViber($params) {
        if ( empty($this->sourceViber) ) {
            return self::craftError('INVSOURCE', 'empty viber name');
        }

        if ( !isset( $params['text']) ) {
            return self::craftError('INVTEXT', 'no text');
        }

        $recipient = self::checkPhone($params['phone']);
        if ( !$recipient ) {
            return self::craftError('INVROUTE', $params['phone']);
        }
        $text = htmlspecialchars($params['text']);
        $btext = htmlspecialchars($params['btext']);
        $blink = $params['blink'];
        $image = $params['image'];
        $alttext = isset($params['alttext']) ? $params['alttext'] : false;

        $params = [
            "action" => "SENDMESSAGE",
            "data" => [
                "recipient" => $recipient,
                "channels" => ['viber'],
                "viber" => [
                    "source" => $this->sourceViber,
                    "text" => $text,
                    "button" => [
                        "caption" => $btext,
                        "url" => $blink
                    ],
                    "image" => $image
                ]
            ]
        ];

        if ( $alttext ) {
            if ( empty($this->sourceSMS) ) {
                self::craftError('INVSOURCE', 'empty sms name');
            } else {
                array_push($params['data']['channels'], 'sms');
                $params['data']['sms'] = [
                    "source" => $this->sourceSMS,
                    "text" => htmlspecialchars($alttext)
                ];
            }
        }

        return $this->apiquery($params);
    }

    static function oclog($message) {
        $log = new Log('smsfly.log');
        $log->write($message);
    }

    static function translit($text) {
        $text_arr = $arChar = preg_split('/(?<!^)(?!$)/u', $text);
        $abc =  Array(
            'а' => 'a',
            'б' => 'b',
            'в' => 'v',
            'г' => 'g',
            'д' => 'd',
            'е' => 'e',
            'ё' => 'jo',
            'ж' => 'zh',
            'з' => 'z',
            'и' => 'i',
            'й' => 'jj',
            'к' => 'k',
            'л' => 'l',
            'м' => 'm',
            'н' => 'n',
            'о' => 'o',
            'п' => 'p',
            'р' => 'r',
            'с' => 's',
            'т' => 't',
            'у' => 'u',
            'ф' => 'f',
            'х' => 'kh',
            'ц' => 'c',
            'ч' => 'ch',
            'ш' => 'sh',
            'щ' => 'shh',
            'ъ' => '"',
            'ы' => 'y',
            'ь' => "'",
            'э' => 'eh',
            'ю' => 'ju',
            'я' => 'ja',
            'А' => 'A',
            'Б' => 'B',
            'В' => 'V',
            'Г' => 'G',
            'Д' => 'D',
            'Е' => 'E',
            'Ё' => 'Jo',
            'Ж' => 'Zh',
            'З' => 'Z',
            'И' => 'I',
            'Й' => 'Jj',
            'К' => 'K',
            'Л' => 'L',
            'М' => 'M',
            'Н' => 'N',
            'О' => 'O',
            'П' => 'P',
            'Р' => 'R',
            'С' => 'S',
            'Т' => 'T',
            'У' => 'U',
            'Ф' => 'F',
            'Х' => 'Kh',
            'Ц' => 'C',
            'Ч' => 'Ch',
            'Ш' => 'Sh',
            'Щ' => 'Shh',
            'Ъ' => '""',
            'Ы' => 'Y',
            'Ь' => "''",
            'Э' => 'Eh',
            'Ю' => 'Ju',
            'Я' => 'Ja',
            'Є' => 'E',
            'є' => 'e',
            'і' => 'i',
            'І' => 'I',
            'ї' => 'i',
            'Ї' => 'I',
            '№' => '#'
        );
        $i = 0; $lat = '';

        while (isset($text_arr[$i])) {
            $lat .= isset($abc[$text_arr[$i]]) ? $abc[$text_arr[$i]] : $text_arr[$i];
            $i++;
        }

        return $lat;
    }

    static function checkPhone ($number) {
        $valid_operators = [
            "039" => "kstar",
            "050" => "mts",
            "063" => "life",
            "066" => "mts",
            "067" => "kstar",
            "068" => "kstar",
            "073" => "life",
            "091" => "utel",
            "092" => "peoplenet",
            "093" => "life",
            "094" => "intertelecom",
            "095" => "mts",
            "096" => "kstar",
            "097" => "kstar",
            "098" => "kstar",
            "099" => "mts",
        ];

        preg_match_all("/([0-9]+)/", $number, $matches);
        $number = implode("", $matches[1]);
        $number = str_pad($number, 12, "0", STR_PAD_LEFT);
        $phone = substr($number, -7);
        $operator = substr($number, -10, 3);
        if(!isset($valid_operators[$operator]) || 7 != strlen($phone)) return false;
        return '38'.$operator.$phone;
    }

    static function print_a($val, $name = '---', $var_dump = false, $return = false) {
        if ($return) {
            return "<hr><h3>$name</h3><pre>".(($var_dump) ? var_dump($val):print_r ($val, true))."</pre>";
        }
        $call_from = debug_backtrace();
        if(is_bool($val))
        {
            $val = ($val) ? 'true' : 'false';
        }
        print "<div style=\"text-align: left;\"><pre>--- [".basename($call_from[0]['file'])."][".$call_from[0]['line']."] --- <b>".str_pad($name.' ', 80, "-")."</b>\r\n"; (($var_dump) ? var_dump($val):print_r ($val)); print "</pre></div>";
    }

    static function craftError($statusCode = '', $statusCodeDescription = '') {
        $answer = [];
        $answer['success'] = 0;
        $answer['error'] = array();
        $answer['error']['code'] = $statusCode;
        $answer['error']['date'] = date("Y-m-d H:i:s");
        $answer['error']['description'] = $statusCodeDescription;
        self::oclog("Crafted Error: $statusCode ($statusCodeDescription)");
        return $answer;
    }
}