<?php
class SmsFlyOrder extends Module {
    private $handle;
    private $baseurl = 'http://sms-fly.com/api/api.php';
    private $dirlog = '../modules/smsflyorder/logs/';
    private $logfile = 'smsfly.log';
    private $versiontext = 'prestashop 1.0.1';

    public function __construct() {
        $this->name = 'smsflyorder';
        $this->tab = 'emailing';
        $this->version = '1.0.1';
        $this->author = 'SMS-fly Dev';
        $this->displayName = $this->l('SMS-fly Order Module');
        $this->description = $this->l('Sending sms module using the service SMS-fly');
        $this->bootstrap = true;
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->module_key = '331499a19c06d6d7b094b87401d80de3';
        parent::__construct();
    }

    public function install() {
        if ( !parent::install()
                || !$this->registerHook('newOrder')
                || !Configuration::updateValue('SF_LOGIN', '')
                || !Configuration::updateValue('SF_PASSWORD', '')
                || !Configuration::updateValue('SF_SOURCE', 'InfoCentr')
                || !Configuration::updateValue('SF_USER_ON', 0)
                || !Configuration::updateValue('SF_ADMIN_ON', 0)
                || !Configuration::updateValue('SF_ADMIN_NUM', '')
                || !Configuration::updateValue('SF_ATPL', $this->l('New order №{NUM}. Sum - {SUM}. City - {CITY}'))
                || !Configuration::updateValue('SF_UTPL', $this->l('Dear, {FIRSTNAME}. Your order №{NUM} saved. Sum order - {SUM}.')) )
            return false;
        return true;
    }

    public function hooknewOrder($params) {
        $settings = array();

        if ( (ConfigurationCore::get('SF_ADMIN_ON') == 1) || (ConfigurationCore::get('SF_USER_ON') == 1) ) {
            $cart = new Cart($params['cart']->id);
            $address = new Address($params['cart']->id_address_delivery);
            $currency = new Currency($params['cart']->id_currency);
            $phone = $address->phone_mobile ? $address->phone_mobile : $address->phone;
            $search = array('{FIRSTNAME}', '{LASTNAME}', '{CITY}', '{NUM}', '{SUM}', '{SHOP_NAME}');
            $replace = array($address->firstname, $address->lastname, $address->city, $params['order']->id, $cart->getOrderTotal().' '.$currency->sign, 'SHOP_NAME');

            if ( ConfigurationCore::get('SF_ADMIN_ON') == 1 ) {
                $settings['SF_PHONE'] = ConfigurationCore::get('SF_ADMIN_NUM');
                $settings['SF_TEXT'] = str_replace($search, $replace, ConfigurationCore::get('SF_ATPL'));
                $this->sendSms($settings);
            }

            if ( ConfigurationCore::get('SF_USER_ON') == 1 ) {
                $settings['SF_PHONE'] = $phone;
                $settings['SF_TEXT'] = str_replace($search, $replace, ConfigurationCore::get('SF_UTPL'));
                $this->sendSms($settings);
            }
        }
    }

    public function uninstall() {
        if ( !parent::uninstall()
                || !Configuration::deleteByName('SF_LOGIN')
                || !Configuration::deleteByName('SF_PASSWORD')
                || !Configuration::deleteByName('SF_SOURCE')
                || !Configuration::deleteByName('SF_USER_ON')
                || !Configuration::deleteByName('SF_ADMIN_ON')
                || !Configuration::deleteByName('SF_ADMIN_NUM')
                || !Configuration::deleteByName('SF_ATPL')
                || !Configuration::deleteByName('SF_UTPL') )
            return false;
        return true;
    }

    private function processConfig () {
        if ( Tools::isSubmit('sf_form_apply') ) {
            ConfigurationCore::updateValue('SF_LOGIN', Tools::getValue('sf_login'));
            ConfigurationCore::updateValue('SF_PASSWORD', Tools::getValue('sf_password'));
            ConfigurationCore::updateValue('SF_SOURCE', Tools::getValue('sf_source'));
            ConfigurationCore::updateValue('SF_USER_ON', Tools::getValue('sf_user_on'));
            ConfigurationCore::updateValue('SF_ADMIN_ON', Tools::getValue('sf_admin_on'));
            ConfigurationCore::updateValue('SF_ADMIN_NUM', Tools::getValue('sf_admin_num'));
            ConfigurationCore::updateValue('SF_ATPL', Tools::getValue('sf_atpl'));
            ConfigurationCore::updateValue('SF_UTPL', Tools::getValue('sf_utpl'));
            $this->context->smarty->assign('confirmation', 'ok');
        }

        if ( Tools::isSubmit('sf_form_test') ) {
            $this->testSms();
            $this->context->smarty->assign('test', 'ok');
        }

        if ( Tools::isSubmit('sf_form_balance')) {
            $balance = $this->getBalance();
            $this->context->smarty->assign('balance',$balance);
        }
    }

    private function assignConfig () {
        $this->context->smarty->assign('sf_login'       ,ConfigurationCore::get('SF_LOGIN'));
        $this->context->smarty->assign('sf_password'    ,ConfigurationCore::get('SF_PASSWORD'));
        $this->context->smarty->assign('sf_source'      ,ConfigurationCore::get('SF_SOURCE'));
        $this->context->smarty->assign('sf_user_on'     ,ConfigurationCore::get('SF_USER_ON'));
        $this->context->smarty->assign('sf_admin_on'    ,ConfigurationCore::get('SF_ADMIN_ON'));
        $this->context->smarty->assign('sf_admin_num'   ,ConfigurationCore::get('SF_ADMIN_NUM'));
        $this->context->smarty->assign('sf_atpl'        ,ConfigurationCore::get('SF_ATPL'));
        $this->context->smarty->assign('sf_utpl'        ,ConfigurationCore::get('SF_UTPL'));
        $this->context->smarty->assign('tpl_desc'       ,
            $this->l('{NUM} - number order; {SUM} - sum order; {FIRSTNAME} - first name; {LASTNAME} - last name; {CITY} - city customer; {SHOP_NAME} - shop name') );
    }

    public function getContent() {
        $this->processConfig();
        $this->assignConfig();
        return $this->display (__FILE__,'getContent.tpl');
    }

    private function testSms()
    {
        $settings['SF_PHONE'] = ConfigurationCore::get('SF_ADMIN_NUM');
        $settings['SF_TEXT'] = "Prestashop тестовое сообщение. Prestashop test message.";
        $this->sendSms($settings);
    }

    public function sendSms($settings) {
        $source         = ConfigurationCore::get('SF_SOURCE');
        $recipient      = $settings['SF_PHONE'];
        $text           = $settings['SF_TEXT'];
        $start_time     = 'AUTO';
        $end_time       = 'AUTO';
        $rate           = 1;
        $lifetime       = 4;
        $description    = '';
        $version        = $this->versiontext;
        //$params['to'] = preg_replace("/[^0-9+]/", '', $params['to']);

        $textQuery 	 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        $textQuery 	.= "<request>";
        $textQuery 	.= "<operation>SENDSMS</operation>";
        $textQuery 	.= '		<message start_time="'.$start_time.'" end_time="'.$end_time.'" lifetime="'.$lifetime.'" rate="'.$rate.'" desc="'.$description.'" source="'.$source.'" version="'.$version.'">'."\n";
        $textQuery 	.= "		<body>".$text."</body>";
        $textQuery 	.= "		<recipient>".$recipient."</recipient>";
        $textQuery 	.=  "</message>";
        $textQuery 	.= "</request>";

        $this->sfQuery($textQuery);
    }

    private function getBalance() {
        $textQuery 	 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        $textQuery 	.= "<request>";
        $textQuery 	.= "<operation>GETBALANCE</operation>";
        $textQuery 	.= "</request>";

        return $this->sfQuery($textQuery);
    }

    private function sfQuery ($textQuery) {
        $user = ConfigurationCore::get('SF_LOGIN');
        $password = ConfigurationCore::get('SF_PASSWORD');

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERPWD , $user.':'.$password);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_URL, $this->baseurl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: text/xml", "Accept: text/xml"));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $textQuery);
        $result = curl_exec($ch);
        curl_close($ch);

        if ($result) {
            $this -> write_log($result.serialize());
            return $result.serialize();
        }
    }

    public function write_log($message) {
        $this->handle = fopen($this->dirlog . $this->logfile, 'a');
        fwrite($this->handle, date('Y-m-d G:i:s') . ' - ' . print_r($message, true) . "\n");
        fclose($this->handle);
    }
}